#pragma once
#include <vector>
#include <queue>

struct Dinic {
    struct Edge { int to, cap, rev; };
    int n;
    std::vector<std::vector<Edge>> g;
    std::vector<int> level, it;

    Dinic(int n) : n(n), g(n), level(n), it(n) {}

    void add_edge(int u, int v, int c) {
        g[u].push_back({ v, c, (int)g[v].size() });
        g[v].push_back({ u, 0, (int)g[u].size() - 1 });
    }

    bool bfs(int s, int t) {
        std::fill(level.begin(), level.end(), -1);
        std::queue<int> q;
        level[s] = 0;
        q.push(s);
        while (!q.empty()) {
            int v = q.front(); q.pop();
            for (auto& e : g[v])
                if (e.cap && level[e.to] < 0) {
                    level[e.to] = level[v] + 1;
                    q.push(e.to);
                }
        }
        return level[t] >= 0;
    }

    int dfs(int v, int t, int f) {
        if (!f || v == t) return f;
        for (int& i = it[v]; i < (int)g[v].size(); ++i) {
            auto& e = g[v][i];
            if (e.cap && level[e.to] == level[v] + 1) {
                int pushed = dfs(e.to, t, std::min(f, e.cap));
                if (pushed) {
                    e.cap -= pushed;
                    g[e.to][e.rev].cap += pushed;
                    return pushed;
                }
            }
        }
        return 0;
    }

    int max_flow(int s, int t) {
        int flow = 0;
        while (bfs(s, t)) {
            std::fill(it.begin(), it.end(), 0);
            while (int pushed = dfs(s, t, 1e9))
                flow += pushed;
        }
        return flow;
    }
};
